﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Seating_Chart
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void displayPriceButton_Click(object sender, EventArgs e)
        {
            // Zmienne dla wybranego rzędu i miejsca.
            int row, col;

            // Stałe określające maksymalne indeksy rzędu i miejsca.
            const int MAX_ROW = 5;
            const int MAX_COL = 3;

            // Utworzenie tablicy wraz z cenami poszczególnych miejsc. 
            decimal[,] prices = { {450m, 450m, 450m, 450m},
                           {425m, 425m, 425m, 425m},
                           {400m, 400m, 400m, 400m},
                           {375m, 375m, 375m, 375m},
                           {375m, 375m, 375m, 375m},
                           {350m, 350m, 350m, 350m}
                         };

            // Pobranie numeru rzędu wybranego przez użytkownika. 
            if (int.TryParse(rowTextBox.Text, out row))
            {
                // Pobranie numeru miejsca wybranego przez użytkownika. 
                if (int.TryParse(colTextBox.Text, out col))
                {
                    // Upewnienie się, że numer rzędu jest z dozwolonego przedziału. 
                    if (row >= 0 && row <= MAX_ROW)
                    {
                        // Upewnienie się, że numer miejsca jest z dozwolonego przedziału. 
                        if (col >= 0 && col <= MAX_COL)
                        {
                            // Wyświetlenie ceny wybranego miejsca.
                            priceLabel.Text =
                                prices[row, col].ToString("c");
                        }
                        else
                        {
                            // Komunikat błędu w przypadku nieprawidłowego numeru miejsca. 
                            MessageBox.Show("Miejsce musi mieć numer od 0 do " +
                                MAX_COL);
                        }
                    }
                    else
                    {
                        // Komunikat błędu w przypadku nieprawidłowego numeru rzędu. 
                        MessageBox.Show("Rząd musi mieć numer od 0 do " +
                            MAX_ROW);
                    }
                }
                else
                {
                    // Wyświetlenie komunikatu błędu, jeśli dla miejsca podano wartość inną niż liczba całkowita.
                    MessageBox.Show("Podaj liczbę całkowitą jako numer miejsca.");
                }
            }
            else
            {
                // Wyświetlenie komunikatu błędu, jeśli dla rzędu podano wartość inną niż liczba całkowita. 
                MessageBox.Show("Podaj liczbę całkowitą jako numer rzędu.");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
